(function($){
	$.fn.hasVerticalScrollBar = function() {
		return this.get(0) ? this.get(0).scrollHeight > this.innerHeight() : false;
	};
	
	$.fn.disableIframes = function() {
		$(this).find('iframe').each(function(){
			var bla = $(this).attr('src');
			if( $(this).attr('data-src') === undefined ){
				$(this).attr('data-src',  bla);
			}
			$(this).attr('src', '');
		});
	    return this;
	};
	$.fn.enableIframes = function() {
		//console.log(this);
		$(this).find('iframe').each(function(){
			
			if( $(this).attr('data-src')===''){
				$(this).attr('data-src', $(this).attr('src') );
			}
			if( $(this).attr('src')!==$(this).attr('data-src') ){ // prevents reloading frame
				$(this).attr('src', $(this).attr('data-src') );
			}
		});
	    return this;
	};
	
})(jQuery);

var changeView = function(dir){
	var states = ['chapters', 'noChapters', 'referencesZoom'];
	var currentStateNum = 0;
	$(states).each(function(e){
		if( $("#container").hasClass(states[e]) ){
			currentStateNum = e;
			return false; // (== break)
		}
		//currentStateNum++;
		//window.console.log(currentStateNum);
	});
	
	if(currentStateNum<0){
		return;
	}
	
	// unfocus references
	$("#overlay").triggerHandler('click');
	
	var nextState = ((currentStateNum+dir) );//%(states.length) ) ];
	if(nextState < 0){
		nextState = 0;
	}
	else if(nextState > (states.length-1)){
		nextState = (states.length-1);
	}
	//window.console.log(nextState);
	$("#container").removeClass(states[currentStateNum]).addClass(states[nextState]);
};

var goToChapter = function( menuElement ){
	// sanitize
	menuElement = $(menuElement).first();
	
	var menuItems = $("#chapters_menu").find("ul > li > a");
	//console.log(menuElement[0]);
	if( $(menuElement).hasClass("no_intro") ){
		
		var next;
		var found = false;
		
		var currentIndex = 0;
		menuItems.each(function(){
			if(this === menuElement[0] ){
				found = true;
				return false; // = jquery break
				//console.log("found!");
			}
			currentIndex++;
			//console.log(this);
		});
		//console.log(next);
		if( found ) {
			
			if( $(this).parent('li').hasClass('active') ){
				return;
			}
			
			next = menuItems.eq( (currentIndex+1)%menuItems.length );
			//console.log(next);
			//console.log( $(next.parent("li")[0]).hasClass("active") );
			if( $(next.parent("li")[0]).hasClass("active") ){
				// should go to prev
				next = menuItems.eq( (currentIndex-1)%menuItems.length );
				//console.log("ACTIVE!");
			}
			
			//console.log(next[0]);
			if( next.length > 0){
				goToChapter( $(next) );
				return false;
			}
		}
	}
	
	// unfocus references
	$("#overlay").triggerHandler('click');
	
	menuItems.not(menuElement).parent('li').removeClass('active').parents("li").removeClass("active activeChildren");
	
	$(menuElement).parent("li").addClass('active').parents("li").addClass("active activeChildren");
	
	var section = $(".section-"+$(menuElement).attr('data-uid'));
	if( $(menuElement).parent('li').hasClass('transition')){
		section = section.find('.transition');
	}
	else {
		section = section.find('.screenheight').first();
	}
	
	$(".redaction").find("h1:first-child").filter(".fixed").removeClass("fixed");
	
	//var prevActive = $("screenheight.focused");
	var isotope = section.find('.references .isotope');
	
	$("#container").stop(true).scrollTo(section[0], 400, {
		complete: function(){
			$("#container").append('<div class="removeme">');
			$(".removeme").remove();
			//section.find('.references .isotope').first().isotope({transitionDuration: 0});
			$('section .screenheight').not(section).removeClass('focused');
			isotope.find('.sideRef').enableIframes();
		},
		queue:	false,
		axis:	'y'
	});
	
	// re-size menu if needed.
	var menu = $("#chapters_menu");
	menu.removeClass('collapseForSpace');
	if( menu.hasVerticalScrollBar() ){
		menu.addClass('collapseForSpace');
	}
	
	section.addClass('focused');

	// sort references
	//isotope.isotope('layout');
	isotope.isotope({
		sortBy: 'original-order',
		itemSelector: '.item',
		layoutMode: 'masonryHorizontal',
		masonryHorizontal: {
			rowHeight: ".grid-sizer",
			//gutter: 10 // also referred in a css file
		}
/*
		,getSortData: {
			name: '.name',
			symbol: '.symbol',
			number: '.number parseInt',
			category: '[data-category]',
			weight: function( itemElem ) {
				var weight = $( itemElem ).find('.weight').text();
				return parseFloat( weight.replace( /[\(\)]/g, '') );
			}
		}
*/
	});
	
	//isotope.find('.sideRef').enableIframes();
	$(".screenheight:not(.focused) .sideRef").disableIframes();
/*
	isotope.isotope('once', 'arrangeComplete', function(){
		$('section .screenheight').not(section).removeClass('focused');
		console.log('hmm...'+section);
	});
*/
	//$('section .screenheight').not(section).not(prevActive).removeClass('focused');
	//$('section .screenheight').not(section).not(".focused").removeClass('focused');

	
	//setTimeout( function(){
	//	$('section .screenheight').not(section).removeClass('focused');
	//	console.log('hmm...');
	//}, 400);
	
	// focus on content
	section.find(".redaction").first().focus();
};

var calcDimensions = function(){
	$(".screenheight").height( $(window).height() );
	
	$(".redaction h1:first-child").each( function(){
		$(this).width( $(this).parent().width() );
	});
	
	// re-adjust current scroll position
	var current = $("#chapters_menu").find("ul > li.active > a").last();
	if(current.length > 0){
		goToChapter( current );
	}
};

var navigateChapters = function(offset){
	var current = $("#chapters_menu").find("ul > li.active > a").last();
	var menuItems = $("#chapters_menu").find("ul > li > a");
	if( current.length < 1 ){
		current = menuItems.first();
	}
	// deselect
	//current.parent('li').removeClass('active');
	
	var currentIndex = 0;
	menuItems.each(function(){
		if( this === current[0] ){
			goToChapter( $(menuItems.eq( (currentIndex+offset)%menuItems.length ).first()) );
			return false;// == break in each();
		}
		currentIndex++;
	});
};

var bindMenu = function(){
	$("#chapters_menu").find("ul > li > a").each(function(){
		$(this).click(function(e){
			e.preventDefault();
			e.stopPropagation();
			goToChapter($(this));
		});
	});
	
	$(".menu_prev_chap").click(function(){
		navigateChapters(-1);
	});
	$(".menu_next_chap").click(function(){
		navigateChapters(+1);
	});
	
	$("#chapters_menu").click(function(e){
		e.preventDefault();
		e.stopPropagation();
		if( $("#container").hasClass("chapters") ){
			changeView(+1);
		}
		else {
			changeView(-1);
		}
	}).find("ul").click(function(e){
		e.preventDefault();
		e.stopPropagation();
	});
	$(".redaction").click(function(e){
		if( $("#container").hasClass("referencesZoom") ){
			e.preventDefault();
			changeView(-1);
		}
	});
	
	$("main.main").prepend( $('<div class="refZoomTrigger"></div>').append( $('<div class="refZoomTriggerInner">▶</div>').click(function(){
		changeView(+1);
	}) ));
	
	$(document, window).keydown(function(e){
		// UP DOWN ARROWS
		if(e.which===38){
			navigateChapters(-1);
		}
		else if(e.which===40){
			navigateChapters(+1);
		}
		// LEFT RIGHT ARROWS
		else if(e.which===37){
			changeView(-1);
		}
		else if(e.which===39){
			changeView(+1);
		}
		//else console.log(e.which);
	}).focus();
	
};

var bindRedactionScroll = function(){
	$(".redaction").each( function(){
		// check title place
		var h1 = $(this).find('h1').first();
		
		//var p = h1.next('p');
		//p.css('paddingTop', p.css('paddingTop')+h1.height() );

		// reminder offset for later
		h1.attr('data-offset', h1.position().top - $(this).position().top );
		
		var redaction = $(this);
		redaction.attr('data-scrolled',0);
		
		var treshold = 500.0;
		
		var goBackInterval;// = setInterval(scrollBack, 1000/24);
		function scrollBack(){
			if( !redaction.parent(".screenheight").hasClass("focused") ){
				return;
			}
			
			var scrollExtra = parseInt( redaction.attr('data-scrolled') ,10);
			if( isNaN(scrollExtra) ){
				scrollExtra = 0;
			}
			var velocity = parseInt( redaction.attr('data-velocity') , 10);
			if( isNaN(velocity) ){
				velocity = 0;
			}
			//window.console.log(scrollExtra);
			if(scrollExtra !== 0){
				if( scrollExtra > 0){
					scrollExtra -= velocity;
					if(scrollExtra < 0){ scrollExtra = 0; }
				}
				else{
					scrollExtra += velocity;
					if(scrollExtra > 0){ scrollExtra = 0; }
				}
				velocity +=2;
				if(velocity > 25){
					velocity = 25;
				}
				redaction.attr('data-scrolled', scrollExtra );//.triggerHandler('mousewheel');
			}
			else {
				velocity = 0;
				clearInterval( goBackInterval );
			}
			
			redaction.attr('data-velocity', velocity );
			
			//scrollExtra = abs(scrollExtra);
			var percentage = parseInt((Math.abs(scrollExtra)/treshold)*100,10);
			//console.log(percentage);
			redaction.css('backgroundSize', parseInt(100+(100-(percentage)),10) +'% '+percentage+'%');
		};
		
		var touchPos = {scrolling:false,x:0,y:0};
		
		redaction.on('mousewheel', function(event, dataOffset) {
			//window.console.log(event.deltaX, event.deltaY, event.deltaFactor);
			
			
			// check title position
			if( !h1.hasClass("fixed") && h1.attr('data-offset') <= $(this).scrollTop() ){
				h1.addClass("fixed");
			}
			else if( h1.hasClass("fixed") && h1.attr('data-offset') > $(this).scrollTop() ) {
				h1.removeClass("fixed");
			}
			
			// load next page ?
			var scrolled = $(this).scrollTop()/( this.scrollHeight - $(this).innerHeight() );
			var scrollExtra = parseInt($(this).attr('data-scrolled'),10);
			if( isNaN(scrollExtra) ){
				scrollExtra = 0;
			}
			//window.console.log( scrolled );
			if( scrolled >= 1 || !scrolled ){
				clearInterval( goBackInterval );
				goBackInterval = setInterval(scrollBack, 1000/24);
				
				//console.log( typeof(dataOffset.deltaY) );
				if( typeof(dataOffset.deltaY)=='number' ){
					scrollExtra -= dataOffset.deltaY;
				} else {
					scrollExtra -= event.deltaY
				}
				//window.console.log(scrollExtra);
				redaction.attr('data-velocity', '0' );
			}
			else {
				scrollExtra=0;
			}
			
			// reached ?
			if(scrollExtra > treshold ){
				scrollExtra = 0;
				navigateChapters(+1);
				redaction.attr('data-velocity', '0' );
				touchPos.scrolling = false;
				clearInterval( goBackInterval );
			}
			else if( Math.abs(scrollExtra) > treshold ){
				scrollExtra = 0;
				navigateChapters(-1);
				redaction.attr('data-velocity', '0' );
			}
			
			redaction.attr('data-scrolled', scrollExtra );
			if(scrollExtra >= 0) {
				redaction.removeClass('reversedGradient');
			}
			else {
				redaction.addClass('reversedGradient');
			}
			var percentage = parseInt((Math.abs(scrollExtra)/treshold)*100,10);
			//console.log(percentage);
			redaction.css('backgroundSize', parseInt(100+(100-(percentage)),10) +'% '+percentage+'%');
			//window.console.log(scrolled+" - "+scrollExtra+' - '+ (scrollExtra / treshold) );
		});
		
		
		redaction.on('touchstart', function(event){
			if( event.originalEvent.touches[0]){
				touchPos.scrolling = true;
				touchPos.x = event.originalEvent.touches[0].pageX;
				touchPos.y = event.originalEvent.touches[0].pageY;
			}
		}).on('touchmove', function(event){
			if( !touchPos.scrolling || !event.originalEvent.touches[0] ){
				return;
			}
			
			offset = {};

			offset.deltaX = -2.5*(touchPos.x - event.originalEvent.touches[0].pageX);
			offset.deltaY = -2.5*(touchPos.y - event.originalEvent.touches[0].pageY);
			
			//event.deltaY = offset.y;
			redaction.triggerHandler('mousewheel', offset);
			
			touchPos.x = event.originalEvent.touches[0].pageX;
			touchPos.y = event.originalEvent.touches[0].pageY;

			return offset;
		}).on('touchstop', function(event){
			touchPos.scrolling = 0;
		});

	});
};

var buildReferences = function(){
	$("body").append( $('<div id="overlay"></div>').click(function(){
		$("body").removeClass('lightsOn');
		
		$(".reveal").each(function(){
			$(this).removeClass('reveal');
			$(this).css('top', null);
			$(this).css('left', null);
		});
		
		$("#overlay").children().each(function(){
			if($(this).hasClass('ref')){
				$(this).remove();
			}
			else {
				$(this)
					.removeClass('reveal')
					.css('height',null).css('width', null)
					.css('position', 'absolute')
					.css('top', $(this).attr('data-top')).css('left', $(this).attr('data-left'))
					.appendTo(".screenheight.focused .references .isotope");
			}
		});
	}) );
	
	// disable biblio stuff
	$("#fullReferences .sideRef").each(function(){
		//console.log($(this));
		$(this).disableIframes();
	});
	
	$(".redaction").each(function(){
		var redaction = $(this);
		var refsZone = redaction.next(".references");
		
		if( refsZone.length < 1 ) return;
		
		redaction.find(".ref").each(function(){
			
			//var url = $(this).attr('href');
			var uid = $(this).attr('data-uid');
			if( !uid ){
				//console.log(uid);
				return;
			}
			
			$(this).click(function(e){
				e.preventDefault();
				
				if($(this).hasClass('reveal')){
					// lights out please
					$("#overlay").triggerHandler('click');
				}
				else {
					$('.reveal').removeClass('reveal');
					$(".screenheight.focused .ref[data-uid="+$(this).attr('data-uid')+"]").each(function(){
						var clone = $(this).clone(true);
						$("#overlay").append(clone);
						clone.addClass('reveal').css('top', $(this).offset().top ).css('left', $(this).offset().left );
					});
					$(".screenheight.focused .sideRef[data-uid="+$(this).attr('data-uid')+"]").each(function(){
						var el = $(this);
						el.attr('data-top', $(this).css('top')).attr('data-left', $(this).css('left'));
						el.addClass('reveal')
							.height($(this).height()).width($(this).width())
							.css('top', $(this).offset().top ).css('left', $(this).offset().left )
							.css('position', 'fixed');
						
						el.appendTo("#overlay");
					});
					$("body").addClass('lightsOn');
				}
/*
				if($(this).hasClass('reveal')){
					$('.reveal').removeClass('reveal');
					$.revealElements({
						revealClass: '.revealNone',
						wrapperEl: 'body',
						overlayIndex: 8,
						overlayColor: '#000'
					});
				}
				else {
					$(this).addClass('reveal');
					$(".sideRef[data-uid="+$(this).attr('data-uid')+"]").addClass('reveal');
					$.revealElements({
						revealClass: '.reveal',
						wrapperEl: 'body',
						overlayIndex: 8,
						overlayColor: '#000'
					});
				}
*/
			});
			
			var maconery = refsZone.find('.isotope').first();
			//console.log(maconery.find(".sideRef[data-uid="+uid+"]"));
			if( uid && maconery.find(".sideRef[data-uid="+uid+"]").length < 1 ){
				//window.console.log("Loading ref: "+ uid );
				var ref = $("#fullReferences .fullRef[data-uid="+uid+"] .sideRef").first();

				if(ref.length < 1) return;
				
				ref.find('.refMoreInfoLink').click(function(){
					$(this).parent(".sideRefWrapper").parent(".sideRef").first().toggleClass('toggleInfo');
				});
				ref.clone(true).addClass("item reference").appendTo( maconery );
			}
		});
		
		// bind in-text footnotes (plugin broken)
		redaction.find("sup.footnote a").click(function(e){
			e.preventDefault();
			
			var nb = parseInt($(this).attr('id').replace('fnref-', ''),10);
			var elem = redaction.find(".footnotes #fn-"+nb);
			
			if(elem.length > 0){
				redaction.scrollTo(elem[0], 400, {
					complete: function(){
						$("#container").append('<div class="removeme">');
						$(".removeme").remove();
					},
					queue:	false,
					axis:	'y'
				});
			}
		});
		
		redaction.find(".footnotes .footnotereverse a").click(function(e){
			e.preventDefault();
			
			var href = $(this).attr('href');
			var elem = redaction.find("sup.footnote a"+href);
			
			if(elem.length > 0){
				redaction.scrollTo(elem[0], 400, {
					complete: function(){
						$("#container").append('<div class="removeme">');
						$(".removeme").remove();
					},
					queue:	false,
					axis:	'y'
				});
			}
	
		});
	});
	// $grid.isotope({ sortBy: sortValue });
/*
	$('.grid').isotope({
		// options
		itemSelector: '.grid-item',
		layoutMode: 'fitRows'
	});
*/
};

$(function(){
	
	
	$("#menu_close").click(function(e){
		e.preventDefault();
		changeView(-1);
		changeView(-1);
	});
	
	$(window).resize(function(){calcDimensions();});
	calcDimensions();
	
	// make menu scrollable
	bindMenu();
	
	bindRedactionScroll();
	
	buildReferences();
	
	// go to preface
	goToChapter( $("nav#chapters_menu").find("a[data-uid=introduction]").first() );
	//goToChapter( $("nav#chapters_menu").find("a[data-uid=une-pratique-experimentale]").first() );
	
	// externalize targets
	$(".sideRef a[href]").each(function(){
		$(this).attr('target', '_blank');
	});
	
	$('.section-notice-print').remove();
	$("#chapters_menu").find("a[data-uid='notice-print']").remove();
	
	$("body").addClass('loaded');
});